clear all
%Model preliminaries 
ngrid=501;
c_upper=zeros(1,ngrid);
c_lower=zeros(1,ngrid);
c_lower_g=zeros(1,ngrid);
Delta=0.2; 
Rd=1.04;
P=1.20;
gamma=1.2; 
omega=0.0001;

%%
%An economy without guarantors 

%Solve phi_star 
%Parameterization 1 
pi_fun=@(x)(x-(1+1/gamma)*(omega*gamma)^(1/(gamma+1))*x^(gamma/(gamma+1))+omega-Rd);
phi_grid=linspace(0,5,ngrid);
pi_grid=zeros(1,ngrid);
x=linspace(0,1,ngrid);
for i=1:ngrid
    pi_grid(i)=pi_fun(phi_grid(i));
end 

figure 
plot(phi_grid,pi_grid)
[zpc,index]=min(abs(pi_grid));
phi_star=phi_grid(index); 

if phi_star>P || phi_star<omega*gamma 
    error('phi_star is out of range') 
end 

%%
%Introducing guarantors into the economy 
%Additional parameters 
omega_g=8e-7;
c_g=0.01;

%Solve phi_g_star
pi_fun_g=@(x)(x-(1+1/gamma)*(omega_g*gamma)^(1/(gamma+1))*x^(gamma/(gamma+1))+omega_g-c_g);
phi_grid=linspace(0,5,ngrid);
pi_grid=zeros(1,ngrid);
for i=1:ngrid
    pi_grid(i)=pi_fun_g(phi_grid(i));
end 

figure 
plot(phi_grid,pi_grid)
[zpc,index]=min(abs(pi_grid));
phi_g_star=phi_grid(index);
phi_g_star

%%
% Plot iso-guarantee-fee curves 
pi_grid=linspace(0,1,ngrid);
ciso_phi=zeros(ngrid,5);
fee=[0.015 0.02 0.05 0.2];
for i=1:ngrid
    for j=1:4
        if (phi_g_star-fee(j))/pi_grid(i)<0
            ciso_phi(i,j)=(phi_g_star-fee(j))/pi_grid(i)+0.9;
        end 
    end 
end 

subplot(1,2,1) 
ciso_phi_temp=ciso_phi(:,1);
h1 = plot(pi_grid(ciso_phi_temp>0 & ciso_phi_temp<1),ciso_phi_temp(ciso_phi_temp>0 & ciso_phi_temp<1),'k-', 'LineWidth', 1.5);
hold on 
ciso_phi_temp=ciso_phi(:,2);
h2 = plot(pi_grid(ciso_phi_temp>0 & ciso_phi_temp<1),ciso_phi_temp(ciso_phi_temp>0 & ciso_phi_temp<1),'k--', 'LineWidth', 1.5);
hold on 
ciso_phi_temp=ciso_phi(:,3);
h3 = plot(pi_grid(ciso_phi_temp>0 & ciso_phi_temp<1),ciso_phi_temp(ciso_phi_temp>0 & ciso_phi_temp<1),'k:', 'LineWidth', 1.5);
hold on 
ciso_phi_temp=ciso_phi(:,4);
h4 = plot(pi_grid(ciso_phi_temp>0 & ciso_phi_temp<1),ciso_phi_temp(ciso_phi_temp>0 & ciso_phi_temp<1),'k-.', 'LineWidth', 1.5);
xlabel('True Project Type $\underline{\pi}$', 'Interpreter', 'latex','FontSize', 14)
ylabel('Collateral c', 'FontSize', 14)
title('Iso-Fee($\phi$) Curves', 'Interpreter', 'latex', 'FontSize', 14)

legend([h1 h2 h3 h4], '$\phi=1.5\%$','$\phi=2.0\%$','$\phi=5.0\%$','$\phi=20.0\%$','Interpreter','latex','Location','southeast', 'FontSize', 12);
hold off 

subplot(1,2,2) 
Rstar=[1.05 1.10 1.20 1.40];
pi_Rstar=zeros(1,4);
for j=1:4
    pi_Rstar(j)=1-(Rd-0.9)/(Rstar(j)-0.9);
end 
h1=xline(pi_Rstar(1),'k-', 'LineWidth', 1.5);
hold on
h2=xline(pi_Rstar(2),'k--', 'LineWidth', 1.5);
hold on
h3=xline(pi_Rstar(3),'k:', 'LineWidth', 1.5);
hold on 
h4=xline(pi_Rstar(4),'k-.', 'LineWidth', 1.5);
axis([0 1 0 0.9])
xlabel('True Project Type $\underline{\pi}$', 'Interpreter', 'latex','FontSize', 14)
ylabel('Collateral c', 'FontSize', 14)
title('Iso-Rate($R$) Curves', 'Interpreter', 'latex', 'FontSize', 14)

legend([h1 h2 h3 h4], '$R=1.05$','$R=1.10$','$R=1.20$','$R=1.40$','Interpreter','latex','Location','southeast', 'FontSize', 12);
hold off 

set(gcf, 'Position', [10 10 800 600]);
saveas(gcf, './iso_fee_rate.eps', 'epsc')

